*******************************************
      subroutine coeff(alpha,beta,eta,mu,
     & M0,Phi,delta,lambda,D0,vsv,vsh,vp,wfikt,
     & g0r,g0z,g0t,                      
     & xsynt,xdifa1,xdifa2,xdifa3,xdifa4,xdifa5)
*******************************************
* Output       
*    xsynt  :  theoretical displacement 
*    difa(j):  derivations
*    j=1 w.r.t. M0 (shear strength)   
*    j=2 w.r.t. Phi (strike)          
*    j=3 w.r.t. delta (dip)           
*    j=4 w.r.t. lambda (rake)         
*    j=5 w.r.t. D0 (tension strength) 
*                                                
* Input        
*    M0,D0,Phi,delta,lambda (source parameter)
*    g0r(3),g0z(3),g0t(3) elem. Seismograms)  
*    alpha,beta =  azimuth and station incidence   
*    eta = lames lambda, mu = shear modulus   
*    vsv,vsh,vp sensor's vector (p-sv-sh-system)
*    wfict: strength of fiktitious radial sensor
*           for Piezo sensor (use 0 for seismo) 
*******************************************
      implicit real*8 (a-h,o-z)
      real*8 xsynt
      real*8 xdifa1,xdifa2,xdifa3,xdifa4,xdifa5
      real*8 M0,Phi,delta,lambda,D0
      real*8 alpha,beta
      real*8 eta,mu
      real*8 vsv,vsh,vp,wfikt
      real*8 g0r(3),g0z(3),g0t(2) 
********************************************
      t2 = wfikt*dabs(vp)
      t3 = vsv+0.5D0*t2
      t4 = dsin(delta)
      t5 = dcos(lambda)
      t6 = t4*t5
      t7 = dsin(2*Phi)
      t8 = t6*t7
      t9 = dsin(2*delta)
      t10 = dsin(lambda)
      t11 = t9*t10
      t12 = dcos(Phi)
      t13 = t12**2
      t16 = M0*(t8-t11*t13)
      t18 = t4**2
      t21 = D0*(eta+2*mu*t13*t18)
      t22 = dsin(Phi)
      t23 = t22**2
      t26 = M0*(t8+t11*t23)
      t30 = D0*(eta+2*mu*t23*t18)
      t31 = 0.5D0*t16+0.5D0*t21+0.5D0*t26-0.5D0*t30
      t33 = dcos(2.D0*alpha)
      t34 = dcos(beta)
      t35 = t33*t34
      t36 = g0r(1)
      t38 = dsin(beta)
      t39 = t33*t38
      t40 = g0z(1)
      t44 = vsv**2
      t45 = vsh**2
      t49 = vp+wfikt*dsqrt(t44+t45)
      t55 = vsh+0.5D0*t2
      t58 = g0t(1)
      t67 = D0*mu
      t70 = M0*(t6*dcos(2*Phi)+t11*dsin(2*phi)/2)-t67*t7*t18
      t72 = dsin(2.D0*alpha)
      t73 = t72*t34
      t75 = t72*t38
      t88 = dcos(delta)
      t89 = t88*t5
      t92 = dcos(2*delta)*t10
      t98 = -M0*(t89*t12+t92*t22)+t67*t22*t9
      t100 = dcos(alpha)
      t101 = t100*t34
      t102 = g0r(2)
      t104 = t100*t38
      t105 = g0z(2)
      t115 = dsin(alpha)
      t116 = g0t(2)
      t125 = -M0*(t89*t22-t92*t12)-t67*t12*t9
      t127 = t115*t34
      t129 = t115*t38
      t142 = M0*t9*t10
      t143 = t88**2
      t146 = D0*(eta+2*mu*t143)
      t147 = 0.1666666667D0*t26-0.1666666667D0*t30-0.1666666667D0*t16-0.
     #1666666667D0*t21+0.3333333333D0*t142+0.3333333333D0*t146
      t149 = g0r(3)
      t150 = -t36+2*t149
      t152 = g0z(3)
      t153 = -t40+2*t152
      t162 = -0.3333333333D0*t26+0.3333333333D0*t30+0.3333333333D0*t16+0
     #.3333333333D0*t21+0.3333333333D0*t142+0.3333333333D0*t146
      t164 = t36+t149
      t166 = t40+t152
      xsynt = t3*t31*(-t35*t36+t39*t40)+t49*t31*(-t39*t36-t35*t40)+t55*t
     #31*dsin(2*alpha)*t58+t3*t70*(t73*t36-t75*t40)+t49*t70*(t75*t36+t73
     #*t40)+t55*t70*dcos(2*alpha)*t58+t3*t98*(t101*t102-t104*t105)+t49*t
     #98*(t104*t102+t101*t105)-t55*t98*t115*t116+t3*t125*(t127*t102-t129
     #*t105)+t49*t125*(t129*t102+t127*t105)+t55*t125*t100*t116+t3*t147*(
     #t34*t150-t38*t153)+t49*t147*(t38*t150+t34*t153)+t3*t162*(t34*t164-
     #t38*t166)+t49*t162*(t38*t164+t34*t166)
      t2 = wfikt*dabs(vp)
      t3 = vsv+0.5D0*t2
      t5 = dcos(lambda)
      t6 = dsin(delta)*t5
      t10 = dsin(lambda)
      t11 = dsin(2*delta)*t10
      t12 = dcos(Phi)
      t13 = t12**2
      t14 = t11*t13
      t15 = dsin(Phi)
      t16 = t15**2
      t17 = t11*t16
      t18 = 0.1D1*t6*dsin(2*Phi)-0.5D0*t14+0.5D0*t17
      t20 = dcos(2.D0*alpha)
      t21 = dcos(beta)
      t22 = t20*t21
      t23 = g0r(1)
      t25 = dsin(beta)
      t26 = t20*t25
      t27 = g0z(1)
      t31 = vsv**2
      t32 = vsh**2
      t36 = vp+wfikt*dsqrt(t31+t32)
      t42 = vsh+0.5D0*t2
      t45 = g0t(1)
      t52 = t6*dcos(2*Phi)+t11*dsin(2*phi)/2
      t54 = dsin(2.D0*alpha)
      t55 = t54*t21
      t57 = t54*t25
      t71 = dcos(delta)*t5
      t74 = dcos(2*delta)*t10
      t76 = -t71*t12-t74*t15
      t78 = dcos(alpha)
      t79 = t78*t21
      t80 = g0r(2)
      t82 = t78*t25
      t83 = g0z(2)
      t93 = dsin(alpha)
      t94 = g0t(2)
      t99 = -t71*t15+t74*t12
      t101 = t93*t21
      t103 = t93*t25
      t115 = 0.1666666667D0*t17+0.1666666667D0*t14+0.3333333333D0*t11
      t117 = g0r(3)
      t118 = -t23+2*t117
      t120 = g0z(3)
      t121 = -t27+2*t120
      t130 = -0.3333333333D0*t17-0.3333333333D0*t14+0.3333333333D0*t11
      t132 = t23+t117
      t134 = t27+t120
      xdifa1 = t3*t18*(-t22*t23+t26*t27)+t36*t18*(-t26*t23-t22*t27)+t42*
     #t18*dsin(2*alpha)*t45+t3*t52*(t55*t23-t57*t27)+t36*t52*(t57*t23+t5
     #5*t27)+t42*t52*dcos(2*alpha)*t45+t3*t76*(t79*t80-t82*t83)+t36*t76*
     #(t82*t80+t79*t83)-t42*t76*t93*t94+t3*t99*(t101*t80-t103*t83)+t36*t
     #99*(t103*t80+t101*t83)+t42*t99*t78*t94+t3*t115*(t21*t118-t25*t121)
     #+t36*t115*(t25*t118+t21*t121)+t3*t130*(t21*t132-t25*t134)+t36*t130
     #*(t25*t132+t21*t134)
      t2 = wfikt*dabs(vp)
      t3 = vsv+0.5D0*t2
      t4 = dsin(delta)
      t5 = dcos(lambda)
      t7 = dcos(2*Phi)
      t9 = dsin(2*delta)
      t10 = dsin(lambda)
      t12 = dcos(Phi)
      t13 = dsin(Phi)
      t18 = D0*mu
      t19 = t4**2
      t23 = 0.1D1*M0*(2*t4*t5*t7+2*t9*t10*t12*t13)-0.4D1*t18*t12*t19*t13
      t25 = dcos(2.D0*alpha)
      t26 = dcos(beta)
      t27 = t25*t26
      t28 = g0r(1)
      t30 = dsin(beta)
      t31 = t25*t30
      t32 = g0z(1)
      t36 = vsv**2
      t37 = vsh**2
      t41 = vp+wfikt*dsqrt(t36+t37)
      t47 = vsh+0.5D0*t2
      t50 = g0t(1)
      t59 = -2*M0*t4*t5*dsin(2*Phi)-2*t18*t7*t19
      t61 = dsin(2.D0*alpha)
      t62 = t61*t26
      t64 = t61*t30
      t78 = dcos(delta)*t5
      t81 = dcos(2*delta)*t10
      t87 = -M0*(-t78*t13+t81*t12)+t18*t12*t9
      t89 = dcos(alpha)
      t90 = t89*t26
      t91 = g0r(2)
      t93 = t89*t30
      t94 = g0z(2)
      t104 = dsin(alpha)
      t105 = g0t(2)
      t114 = -M0*(t78*t12+t81*t13)+t18*t13*t9
      t116 = t104*t26
      t118 = t104*t30
      xdifa2 = t3*t23*(-t27*t28+t31*t32)+t41*t23*(-t31*t28-t27*t32)+t47*
     #t23*dsin(2*alpha)*t50+t3*t59*(t62*t28-t64*t32)+t41*t59*(t64*t28+t6
     #2*t32)+t47*t59*dcos(2*alpha)*t50+t3*t87*(t90*t91-t93*t94)+t41*t87*
     #(t93*t91+t90*t94)-t47*t87*t104*t105+t3*t114*(t116*t91-t118*t94)+t4
     #1*t114*(t118*t91+t116*t94)+t47*t114*t89*t105
      t2 = wfikt*dabs(vp)
      t3 = vsv+0.5D0*t2
      t4 = dcos(delta)
      t5 = dcos(lambda)
      t6 = t4*t5
      t7 = dsin(2*Phi)
      t8 = t6*t7
      t9 = dcos(2*delta)
      t10 = dsin(lambda)
      t11 = t9*t10
      t12 = dcos(Phi)
      t13 = t12**2
      t16 = M0*(t8-2*t11*t13)
      t17 = D0*mu
      t18 = dsin(delta)
      t21 = t17*t13*t18*t4
      t22 = dsin(Phi)
      t23 = t22**2
      t26 = M0*(t8+2*t11*t23)
      t29 = t17*t23*t18*t4
      t30 = 0.5D0*t16+0.2D1*t21+0.5D0*t26-0.2D1*t29
      t32 = dcos(2.D0*alpha)
      t33 = dcos(beta)
      t34 = t32*t33
      t35 = g0r(1)
      t37 = dsin(beta)
      t38 = t32*t37
      t39 = g0z(1)
      t43 = vsv**2
      t44 = vsh**2
      t48 = vp+wfikt*dsqrt(t43+t44)
      t54 = vsh+0.5D0*t2
      t57 = g0t(1)
      t69 = M0*(t6*dcos(2*Phi)+t11*dsin(2*phi))-2*t17*t7*t18*t4
      t71 = dsin(2.D0*alpha)
      t72 = t71*t33
      t74 = t71*t37
      t87 = t18*t5
      t90 = dsin(2*delta)*t10
      t96 = -M0*(-t87*t12-2*t90*t22)+2*t17*t22*t9
      t98 = dcos(alpha)
      t99 = t98*t33
      t100 = g0r(2)
      t102 = t98*t37
      t103 = g0z(2)
      t113 = dsin(alpha)
      t114 = g0t(2)
      t123 = -M0*(-t87*t22+2*t90*t12)-2*t17*t12*t9
      t125 = t113*t33
      t127 = t113*t37
      t140 = M0*t9*t10
      t142 = t17*t4*t18
      t143 = 0.1666666667D0*t26-0.6666666668D0*t29-0.1666666667D0*t16-0.
     #6666666668D0*t21+0.6666666666D0*t140-0.1333333333D1*t142
      t145 = g0r(3)
      t146 = -t35+2*t145
      t148 = g0z(3)
      t149 = -t39+2*t148
      t158 = -0.3333333333D0*t26+0.1333333333D1*t29+0.3333333333D0*t16+0
     #.1333333333D1*t21+0.6666666666D0*t140-0.1333333333D1*t142
      t160 = t35+t145
      t162 = t39+t148
      xdifa3 = t3*t30*(-t34*t35+t38*t39)+t48*t30*(-t38*t35-t34*t39)+t54*
     #t30*dsin(2*alpha)*t57+t3*t69*(t72*t35-t74*t39)+t48*t69*(t74*t35+t7
     #2*t39)+t54*t69*dcos(2*alpha)*t57+t3*t96*(t99*t100-t102*t103)+t48*t
     #96*(t102*t100+t99*t103)-t54*t96*t113*t114+t3*t123*(t125*t100-t127*
     #t103)+t48*t123*(t127*t100+t125*t103)+t54*t123*t98*t114+t3*t143*(t3
     #3*t146-t37*t149)+t48*t143*(t37*t146+t33*t149)+t3*t158*(t33*t160-t3
     #7*t162)+t48*t158*(t37*t160+t33*t162)
      t2 = wfikt*dabs(vp)
      t3 = vsv+0.5D0*t2
      t5 = dsin(lambda)
      t6 = dsin(delta)*t5
      t8 = t6*dsin(2*Phi)
      t9 = dsin(2*delta)
      t10 = dcos(lambda)
      t11 = t9*t10
      t12 = dcos(Phi)
      t13 = t12**2
      t16 = M0*(-t8-t11*t13)
      t17 = dsin(Phi)
      t18 = t17**2
      t21 = M0*(-t8+t11*t18)
      t22 = 0.5D0*t16+0.5D0*t21
      t24 = dcos(2.D0*alpha)
      t25 = dcos(beta)
      t26 = t24*t25
      t27 = g0r(1)
      t29 = dsin(beta)
      t30 = t24*t29
      t31 = g0z(1)
      t35 = vsv**2
      t36 = vsh**2
      t40 = vp+wfikt*dsqrt(t35+t36)
      t46 = vsh+0.5D0*t2
      t49 = g0t(1)
      t52 = t3*M0
      t57 = -t6*dcos(2*Phi)+t11*dsin(2*phi)/2
      t58 = dsin(2.D0*alpha)
      t59 = t58*t25
      t61 = t58*t29
      t66 = t40*M0
      t72 = t46*M0
      t78 = dcos(delta)*t5
      t81 = dcos(2*delta)*t10
      t83 = -t78*t12+t81*t17
      t84 = dcos(alpha)
      t85 = t84*t25
      t86 = g0r(2)
      t88 = t84*t29
      t89 = g0z(2)
      t99 = dsin(alpha)
      t101 = g0t(2)
      t106 = -t78*t17-t81*t12
      t107 = t99*t25
      t109 = t99*t29
      t123 = M0*t9*t10
      t124 = 0.1666666667D0*t21-0.1666666667D0*t16+0.3333333333D0*t123
      t126 = g0r(3)
      t127 = -t27+2*t126
      t129 = g0z(3)
      t130 = -t31+2*t129
      t139 = -0.3333333333D0*t21+0.3333333333D0*t16+0.3333333333D0*t123
      t141 = t27+t126
      t143 = t31+t129
      xdifa4 = t3*t22*(-t26*t27+t30*t31)+t40*t22*(-t30*t27-t26*t31)+t46*
     #t22*dsin(2*alpha)*t49+t52*t57*(t59*t27-t61*t31)+t66*t57*(t61*t27+t
     #59*t31)+t72*t57*dcos(2*alpha)*t49-t52*t83*(t85*t86-t88*t89)-t66*t8
     #3*(t88*t86+t85*t89)+t72*t83*t99*t101-t52*t106*(t107*t86-t109*t89)-
     #t66*t106*(t109*t86+t107*t89)-t72*t106*t84*t101+t3*t124*(t25*t127-t
     #29*t130)+t40*t124*(t29*t127+t25*t130)+t3*t139*(t25*t141-t29*t143)+
     #t40*t139*(t29*t141+t25*t143)
      t2 = wfikt*dabs(vp)
      t3 = vsv+0.5D0*t2
      t4 = dcos(Phi)
      t5 = t4**2
      t8 = dsin(delta)**2
      t9 = mu*t5*t8
      t10 = dsin(Phi)
      t11 = t10**2
      t13 = mu*t11*t8
      t14 = 0.1D1*t9-t13
      t16 = dcos(2.D0*alpha)
      t17 = dcos(beta)
      t18 = t16*t17
      t19 = g0r(1)
      t21 = dsin(beta)
      t22 = t16*t21
      t23 = g0z(1)
      t27 = vsv**2
      t28 = vsh**2
      t32 = vp+wfikt*dsqrt(t27+t28)
      t38 = vsh+0.5D0*t2
      t41 = g0t(1)
      t44 = t3*mu
      t45 = dsin(2*Phi)
      t46 = t45*t8
      t47 = dsin(2.D0*alpha)
      t48 = t47*t17
      t50 = t47*t21
      t55 = t32*mu
      t61 = t38*mu
      t67 = dsin(2*delta)
      t68 = t10*t67
      t69 = dcos(alpha)
      t70 = t69*t17
      t71 = g0r(2)
      t73 = t69*t21
      t74 = g0z(2)
      t85 = dsin(alpha)
      t87 = g0t(2)
      t90 = t4*t67
      t91 = t85*t17
      t93 = t85*t21
      t108 = dcos(delta)**2
      t109 = mu*t108
      t110 = -0.1D-9*eta-0.3333333334D0*t13-0.3333333334D0*t9+0.66666666
     #66D0*t109
      t112 = g0r(3)
      t113 = -t19+2*t112
      t115 = g0z(3)
      t116 = -t23+2*t115
      t125 = 0.9999999999D0*eta+0.6666666666D0*t13+0.6666666666D0*t9+0.6
     #666666666D0*t109
      t127 = t19+t112
      t129 = t23+t115
      xdifa5 = t3*t14*(-t18*t19+t22*t23)+t32*t14*(-t22*t19-t18*t23)+t38*
     #t14*dsin(2*alpha)*t41-t44*t46*(t48*t19-t50*t23)-t55*t46*(t50*t19+t
     #48*t23)-t61*t45*t8*dcos(2*alpha)*t41+t44*t68*(t70*t71-t73*t74)+t55
     #*t68*(t73*t71+t70*t74)-t61*t10*t67*t85*t87-t44*t90*(t91*t71-t93*t7
     #4)-t55*t90*(t93*t71+t91*t74)-t61*t4*t67*t69*t87+t3*t110*(t17*t113-
     #t21*t116)+t32*t110*(t21*t113+t17*t116)+t3*t125*(t17*t127-t21*t129)
     #+t32*t125*(t21*t127+t17*t129)
      return
      end
                                            
