#!/bin/csh
# S. Cesca, University Hamburg, May 2006
# Source inversion, Location inversion, 

# Data are expected to be in subdir DATA
# GF are expexted to be in subdir GREENn, n number of GF set
# retard.dat files for each GF set should be in these dir, too
# volpis.input is expected to be in the working directory

# In this example, x and y coordinates assume 51 values, 
# changing by 0.01 km (so, from -0.25 to +0.25km with respect
# to central location). Such values can be modified by changing
# blackboard variables gfn, stepp, xp, yp and ending loop 
# conditions): lines to be updated are indicated as: #user option

# Bring data file to working directory
cp DATA/displ* .

#user option
set gfn=0

#user option
set stepp=0.010

#user option
set xp=-25
loop1:

#user option
set yp=-25
loop2:

@ gfn = $gfn + 1

# Bring GF to working directory
cp GREEN$gfn/MT* .
cp GREEN$gfn/SF* .
# Bring retard.dat to working directory
cp GREEN$gfn/retard.dat .

# Run Inversion
volpis.exe <volpis.input

mv result.loc result.old
cat result.old location.dat result.fit > result.loc 

@ yp = $yp + 1
#user option
if ($yp < 26 ) goto loop2

@ xp = $xp + 1
#user option
if ($xp < 26 ) goto loop1
