/* part of the shansyn spherical harmonics package, see COPYRIGHT for license */
/* $Id: shana.h,v 1.15 2005/10/12 19:16:29 becker Exp becker $ */
//
// header file for shana.c, expansion routine
// 
// $Id: shana.h,v 1.15 2005/10/12 19:16:29 becker Exp becker $
//
#include "gmt.h"		/* need to include GMT stuff first */
#include <stdlib.h>
#include <stdio.h>

#include <math.h>
#include "trig_constants.h"
#include "geo_conversions.h"
#include "function_macros.h"
#include "legendre_macros.h"
#include "precision.h"
#include "misc.h"




#ifndef BE_VERBOSE
 #define BE_VERBOSE 0
#else
 #define BE_BERBOSE 1
#endif
/* reduces lmax automatically for trapezoidal integration
   to suit lmax+1 <= nlat */
//#define REDUCE_LMAX
#include "spherical_harmonics_functions.h"

/* #define CHECK_FLOATING_EXCEPTION */
#define EPS_SMALL EPS_COMP_PREC
/* filenames */
#define FST_VEC_FILE_START "vec_p" /* name of first vector component
				      file */
#define SCD_VEC_FILE "vec_t.grd"

/* limit for P array size 
   if P array gets larger, the routine switches to single 
   Legendre function evaluation
*/
#define MEMLIMIT 1000

#ifndef GMT_PRECISION
 #define GMT_PRECISION DATA_PRECISION
#endif

#define STRING_LENGTH 100

/* integration modes */
#define TRAPEZOIDAL 0
#define GAUSSIAN 2
#define LEAST_SQUARES 3

/* operational modes */
#define BLOCK 0
#define CONTOUR 1
#define ASCII_BLOCK 2
#define ASCII_BLOCK_HEADER 3
#define GMT_BLOCK 4
#define POINTS_FOR_A_MATRIX 5
#define POINTS_FOR_AB 6

// default settings
#define DEF_INT_MODE TRAPEZOIDAL
#define DEF_LMAX 31
#define DEF_OPMODE 2
#define DEF_DAMPING 0.0

/*  */
#define TRUE 1
#define FALSE 0


/* function declarations */
void gmt2myconvention_rotate(GMT_PRECISION *,int ,int ,GMT_PRECISION);
void minmax(DATA_PRECISION *, DATA_PRECISION *, DATA_PRECISION *, 
	    DATA_PRECISION *, int );
DATA_PRECISION dist_rad(DATA_PRECISION *, int , int );
void calc_coeff(DATA_PRECISION **,int ,int ,int ,char *,int,DATA_PRECISION *, int ,int,int,
		DATA_PRECISION , DATA_PRECISION , DATA_PRECISION ,
		DATA_PRECISION , DATA_PRECISION ,
		DATA_PRECISION ,int, int,int, COMP_PRECISION);
void phelp(char *name);
void check_opmode(char *, int *, char *,int *, int *);
void field_message(DATA_PRECISION,DATA_PRECISION,DATA_PRECISION,
		   DATA_PRECISION,DATA_PRECISION,DATA_PRECISION,
		   int , int ,DATA_PRECISION,DATA_PRECISION,DATA_PRECISION,char *);

COMP_PRECISION interpolate(COMP_PRECISION *,
			   DATA_PRECISION *,COMP_PRECISION ,
			   int );
void spline(COMP_PRECISION *,COMP_PRECISION *,
	    int n,COMP_PRECISION  ,COMP_PRECISION ,
	    COMP_PRECISION *);
void splint(COMP_PRECISION *,COMP_PRECISION *,
	    COMP_PRECISION *,int ,COMP_PRECISION ,
	    DATA_PRECISION *);
void free_vector(COMP_PRECISION *,long ,long );
COMP_PRECISION *vector(long  ,long);
void make_a(int , int , int , float **, DATA_PRECISION *,int , char *,int,int *,COMP_PRECISION,int,int,float *);
int aij(int , int , int , int , int );

#ifdef USE_LAPACK
/* LAPACK */
extern void sgels_( char *, int *, int *,int *, float *, int *, float *, int *, float *, int *, int *);
void solver_ab_lls(float *, int , int ,float *,char *);
#endif
